; TRYBSRCH.ASM  Demo of BSEARCH routine (MS-DOS version),
;               searches file previously created by MAKENIF.EXE.        
; Copyright (c) 1989 Ziff Communications Co.
; PC Magazine * Ray Duncan
;
; The user is prompted to enter a search key.  The first
; 8 characters of the key are used to search TESTFILE.DAT,
; using the binary search algorithm.  The success or failure 
; of the search is reported along with the record number (if found).
;
; Each record in TESTFILE.DAT is RSIZE bytes long.  Bytes 
; 0 to (KSIZE-1) of the record are the ASCII key for searches
; by BSEARCH.  Bytes KSIZE to (RSIZE-1) of the record
; are initialized to zero and are not used.  RSIZE, KSIZE,
; and the key offset within the record must be kept synchronized
; with MAKENIF.C.
;
; To build TRYBSRCH.EXE you also need BSEARCH.ASM, ITOA.ASM,
; and STRINGS1.ASM.  Enter the following series of commands:
;
;       MASM TRYBSRCH;
;       MASM BSEARCH;
;       MASM ITOA;
;       MASM STRINGS1;
;       LINK TRYBSRCH+BSEARCH+ITOA+STRINGS1;

stdin   equ     0               ; standard input handle
stdout  equ     1               ; standard output handle

cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed
blank   equ     20h             ; ASCII blank

rsize   equ     64              ; TESTFILE.DAT record size
ksize   equ     8               ; TESTFILE.DAT key size
koffs   equ     0               ; offset of key within record

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:_DATA

        extrn   itoa:near
        extrn   bsearch:near

main    proc    near

        mov     ax,_DATA        ; make our data segment
        mov     ds,ax           ; addressable...
        mov     es,ax

        cld                     ; string ops safety first

                                ; open the file TESTFILE.DAT
        mov     dx,offset fname ; DS:DX = filename
        mov     ax,3d00h        ; fxh 3d00h = open, read-only
        int     21h             ; transfer to MS-DOS
        jnc     main1           ; jump if open successful

                                ; open failed, display error
                                ; message and exit...
        mov     dx,offset msg1  ; DS:DX = message address
        mov     cx,msg1_len     ; CX = message length
        mov     bx,stdout       ; BX = standard output handle
        mov     ah,40h          ; fxn 40h = write
        int     21h             ; transfer to MS-DOS
        jmp     main4           ; go perform final exit

main1:  mov     fhandle,ax      ; save file handle

                                ; find filesize in bytes...
        mov     bx,ax           ; BX = handle
        mov     cx,0            ; CX:DX = file offset of 0
        mov     dx,0
        mov     ax,4202h        ; fxn 42h, subf. 2 = seek
                                ; relative to end of file
        int     21h             ; transfer to MS-DOS

        mov     bx,rsize        ; filesize / bytes per record
        div     bx              ; = records in file
        mov     frecs,ax
        
                                ; display "Enter search key: "
main2:  mov     dx,offset msg2  ; DS:DX = message address
        mov     cx,msg2_len     ; CX = message length
        mov     bx,stdout       ; BX = handle
        mov     ah,40h          ; Fxn 40H = write
        int     21h             ; transfer to MS-DOS

        mov     cx,ksize        ; zero out previous key
        mov     di,offset kval
        xor     al,al
        rep stosb

        mov     cx,6            ; remove previous record
        mov     di,offset msg3a ; number from output string
        mov     al,blank
        rep stosb

                                ; get search key from user
        mov     dx,offset kval  ; DS:DX = input buffer
        mov     cx,80           ; CX = max input length   
        mov     bx,stdin        ; BX = handle             
        mov     ah,3fh          ; Fxn 3FH = read          
        int     21h             ; transfer to MS-DOS      

        cmp     ax,2            ; was anything entered?
        je      main4           ; empty line, exit

        mov     bx,ax           ; remove CR-LF from input
        mov     word ptr [bx+kval-2],0

                                ; set up for binary search
        mov     bx,fhandle      ; file handle
        mov     cx,rsize        ; record size   
        mov     dx,offset fbuff ; record buffer
        mov     si,0            ; first (left) record
        mov     di,frecs        ; last (right) record
        dec     di
        mov     bp,offset key   ; key structure address
        call    bsearch         ; call search routine
        jnz     main3           ; jump if record not found

        mov     si,offset msg3a ; convert record number
        mov     cx,10           ; to ASCII and store in output
        call    itoa

                                ; display 'record number is nnnn'
        mov     dx,offset msg3  ; DS:DX = message address
        mov     cx,msg3_len     ; CX = message length
        mov     bx,stdout       ; BX = standard output handle
        mov     ah,40h          ; Fxn 40h = write
        int     21h             ; transfer to MS-DOS

        jmp     main2           ; get another search key

main3:                          ; display 'record not found'
        mov     dx,offset msg4  ; DS:DX = message address
        mov     cx,msg4_len     ; CX = message length
        mov     bx,stdout       ; BX = standard output handle
        mov     ah,40h          ; Fxn 40h = write
        int     21h             ; transfer to MS-DOS

        jmp     main2           ; get another search key

main4:  mov     ax,4c00h        ; final exit to MS-DOS
        int     21h

main    endp

_TEXT   ends


_DATA   segment word public 'DATA'

fname   db      'TESTFILE.DAT',0 ; file created by MAKENIF.C
fhandle dw      ?               ; handle for TESTFILE.DAT
frecs   dw      ?               ; records in file
fbuff   db      rsize dup (0)   ; file record buffer

key     dw      ksize           ; length of key data
        dw      koffs           ; offset of key within record
kval    db      80 dup (0)      ; actual key data

msg1    db      cr,lf
        db      'Can''t open TESTFILE.DAT'
        db      cr,lf
msg1_len equ $-msg1

msg2    db      cr,lf
        db      'Enter search key: '
msg2_len equ $-msg2

msg3    db      cr,lf
        db      'Record number is: '
msg3a   db      6 dup (blank)
        db      cr,lf
msg3_len equ $-msg3

msg4    db      cr,lf
        db      'Record not found'
        db      cr,lf
msg4_len equ $-msg4

_DATA   ends


STACK   segment para stack 'STACK'
        
        db      4096 dup (?)

STACK   ends

        end     main
